# -*- coding: utf-8 -*-
from setuphelpers import *
import glob
import os

app_name = "luanti"
app_dir = makepath(programfiles, app_name)
app_path = makepath(app_dir,"bin", "luanti.exe")
audit_version = False

def get_installed_version(app_path):
    return get_file_properties(app_path).get("FileVersion", "")

def install():
    
     # Trouver le fichier zip
    zip_name = glob.glob(f"{app_name}*.zip")[0]
    unzip_dest = makepath(".", "temp_dezip")
    
    # Supprimer le répertoire temporaire s'il existe déjà
    if isdir(unzip_dest):
        remove_tree(unzip_dest)
    
    # Extraire le fichier zip
    print(f"Extracting: {zip_name} to: {unzip_dest}")
    unzip(zip_name, unzip_dest)
    
    # Vérifier le contenu extrait
    extracted_content = os.listdir(unzip_dest)
    print(f"Extracted content in {unzip_dest}: {extracted_content}")
    
    # Vérifier si le contenu extrait est un autre fichier ZIP
    while len(extracted_content) == 1 and extracted_content[0].endswith(".zip"):
        inner_zip_path = makepath(unzip_dest, extracted_content[0])
        unzip(inner_zip_path, unzip_dest)
        extracted_content = os.listdir(unzip_dest)
        print(f"Extracted another ZIP file. New content: {extracted_content}")
    
    # Supposons que le répertoire extrait soit le premier dossier dans `extracted_content`
    extracted_dir = makepath(unzip_dest, extracted_content[0])
    
    # Vérifier si le répertoire extrait contient `bin/luanti.exe`
    if not isdir(extracted_dir) or not os.path.exists(makepath(extracted_dir, "bin", "luanti.exe")):
        raise Exception(f"Expected directory structure not found in extracted content: {extracted_dir}")
    
    # Supprimer l'ancien répertoire de l'application s'il existe
    if isdir(app_dir):
        remove_tree(app_dir)
    
    # Déplacer le contenu du répertoire extrait vers le répertoire d'installation final
    copytree2(extracted_dir, app_dir, onreplace=default_overwrite)
    
    # Supprimer le répertoire temporaire
    remove_tree(unzip_dest)
    
    # Créer les raccourcis personnalisés
    create_desktop_shortcut(app_name, target=app_path)
    create_programs_menu_shortcut(app_name, target=app_path)

def audit():
    # Auditing software
    audit_status = "OK"
    installed_version = get_installed_version(app_path)
    if Version(installed_version) < Version(control.get_software_version()) and audit_version:
        print("%s is installed in version (%s) instead of (%s)" % (app_name, installed_version, control.get_software_version()))
        audit_status = "WARNING"
    elif isdir(app_dir) and not dir_is_empty(app_dir):
        print("%s (%s) is installed" % (app_name, installed_version))
        audit_status = "OK"
    else:
        print("%s is not installed" % app_name)
        audit_status = "ERROR"
    return audit_status

def uninstall():
    # Uninstalling software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir):
        remove_tree(app_dir)

    # Removing shortcuts
    remove_desktop_shortcut(app_name)
    remove_programs_menu_shortcut(app_name)