/*
Franc (language detection) returns detailed iso-6393 codes, but the Bergamot models are defined using 6391 codes. It's not clear exactly which variants of a language each model encompasses.
This list is based on https://github.com/wooorm/iso-639-3/blob/main/iso6393.js; it represents a best-guess mapping of every language to its language group or the nearest 6391 code. The short codes may not be entirely accurate, but they probably represent the best translation model available regardless.
*/

export default {
  aar: 'aa',
  abk: 'ab',
  afr: 'af',
  aka: 'ak',
  amh: 'am',
  aao: 'ar',
  abh: 'tg',
  abv: 'ar',
  acm: 'ar',
  acq: 'ar',
  acw: 'ar',
  acx: 'ar',
  acy: 'ar',
  adf: 'ar',
  aeb: 'ar',
  aec: 'ar',
  afb: 'ar',
  ajp: 'ar',
  ajt: 'ar',
  aju: 'ar',
  apc: 'ar',
  apd: 'ar',
  ara: 'ar',
  arb: 'ar',
  arq: 'ar',
  ars: 'ar',
  ary: 'ar',
  arz: 'ar',
  auz: 'uz',
  avl: 'ar',
  ayh: 'ar',
  ayl: 'ar',
  ayn: 'ar',
  ayp: 'ar',
  jrb: 'ar',
  jye: 'ar',
  pga: 'ar',
  shu: 'ar',
  sqr: 'ar',
  ssh: 'ar',
  xaa: 'ar',
  yhd: 'ar',
  yud: 'ar',
  arg: 'an',
  asm: 'as',
  ava: 'av',
  ave: 'ae',
  ayc: 'ay',
  aym: 'ay',
  ayr: 'ay',
  azb: 'az',
  aze: 'az',
  azj: 'az',
  bak: 'ba',
  bam: 'bm',
  bel: 'be',
  ben: 'bn',
  bis: 'bi',
  adx: 'bo',
  bod: 'bo',
  khg: 'bo',
  lsn: 'bo',
  otb: 'bo',
  xct: 'bo',
  bos: 'bs',
  bre: 'br',
  obt: 'br',
  xbm: 'br',
  bqn: 'bg',
  bul: 'bg',
  cat: 'ca',
  csc: 'ca',
  ces: 'cs',
  cse: 'cs',
  cha: 'ch',
  che: 'ce',
  chu: 'cu',
  chv: 'cv',
  cnx: 'kw',
  cor: 'kw',
  oco: 'kw',
  cos: 'co',
  cre: 'cr',
  crj: 'cr',
  crk: 'cr',
  crl: 'cr',
  crm: 'cr',
  csw: 'cr',
  cwd: 'cr',
  mus: 'cr',
  cym: 'cy',
  owl: 'cy',
  rmw: 'cy',
  wlm: 'cy',
  dan: 'da',
  dsl: 'da',
  rmd: 'da',
  deu: 'de',
  gct: 'de',
  geh: 'de',
  gmh: 'de',
  gml: 'de',
  goh: 'de',
  gsg: 'de',
  gsw: 'de',
  nds: 'de',
  pdc: 'de',
  sgg: 'de',
  div: 'dv',
  dzo: 'dz',
  ell: 'el',
  aig: 'en',
  ang: 'en',
  bah: 'en',
  bzj: 'en',
  bzk: 'en',
  cpi: 'zh',
  eng: 'en',
  enm: 'en',
  fpe: 'en',
  gcl: 'en',
  gpe: 'en',
  gul: 'en',
  gyn: 'en',
  hwc: 'en',
  icr: 'en',
  jam: 'en',
  lir: 'en',
  svc: 'en',
  tch: 'en',
  tgh: 'en',
  trf: 'en',
  vic: 'en',
  epo: 'eo',
  ekk: 'et',
  eso: 'et',
  est: 'et',
  eus: 'eu',
  ewe: 'ee',
  fao: 'fo',
  fas: 'fa',
  jpr: 'fa',
  peo: 'fa',
  pes: 'fa',
  psc: 'fa',
  xmn: 'fa',
  fij: 'fj',
  wyy: 'fj',
  fin: 'fi',
  fit: 'fi',
  fkv: 'fi',
  fse: 'fi',
  rmf: 'fi',
  acf: 'fr',
  crs: 'fr',
  fra: 'fr',
  frc: 'fr',
  frm: 'fr',
  fro: 'fr',
  fsl: 'fr',
  gcf: 'fr',
  gcr: 'fr',
  kmv: 'fr',
  rcf: 'fr',
  scf: 'fr',
  ssr: 'fr',
  fry: 'fy',
  ful: 'ff',
  ghc: 'gd',
  gla: 'gd',
  gle: 'ga',
  isg: 'ga',
  mga: 'ga',
  pgl: 'ga',
  sga: 'ga',
  glg: 'gl',
  glv: 'gv',
  grn: 'gn',
  guj: 'gu',
  hat: 'ht',
  hvc: 'ht',
  hau: 'ha',
  hsl: 'ha',
  hbs: 'hr',
  hbo: 'he',
  heb: 'he',
  her: 'hz',
  hca: 'hi',
  hif: 'hi',
  hin: 'hi',
  hmo: 'ho',
  hrv: 'hr',
  hsh: 'hu',
  hun: 'hu',
  ohu: 'hu',
  aen: 'hy',
  axm: 'hy',
  hye: 'hy',
  hyw: 'hy',
  xcl: 'hy',
  ibo: 'ig',
  idc: 'io',
  ido: 'io',
  idu: 'io',
  iii: 'ii',
  ike: 'iu',
  iku: 'iu',
  ile: 'ie',
  ina: 'ia',
  bdl: 'id',
  ind: 'id',
  inl: 'id',
  pea: 'id',
  ipk: 'ik',
  icl: 'is',
  isl: 'is',
  ise: 'it',
  ita: 'it',
  itk: 'it',
  slf: 'it',
  jas: 'jv',
  jav: 'jv',
  jvn: 'jv',
  jpn: 'ja',
  jsl: 'ja',
  ojp: 'ja',
  kal: 'kl',
  kan: 'kn',
  kfi: 'kn',
  kas: 'ks',
  jge: 'ka',
  kat: 'ka',
  oge: 'ka',
  bms: 'kr',
  kau: 'kr',
  kby: 'kr',
  knc: 'kr',
  krt: 'kr',
  kaz: 'kk',
  khm: 'km',
  kxm: 'km',
  kik: 'ki',
  kin: 'rw',
  kir: 'ky',
  koi: 'kv',
  kom: 'kv',
  kpv: 'kv',
  xoi: 'kv',
  kon: 'kg',
  kwy: 'kg',
  kor: 'ko',
  kvk: 'ko',
  okm: 'ko',
  oko: 'ko',
  kua: 'kj',
  ckb: 'ku',
  kmr: 'ku',
  kur: 'ku',
  sdh: 'ku',
  bgl: 'lo',
  lao: 'lo',
  lbg: 'lo',
  lso: 'lo',
  lwm: 'lo',
  nlq: 'lo',
  tsl: 'lo',
  tyl: 'lo',
  lat: 'la',
  lav: 'lv',
  lsl: 'lv',
  lvs: 'lv',
  lim: 'li',
  lin: 'ln',
  lit: 'lt',
  lls: 'lt',
  olt: 'lt',
  ltz: 'lb',
  lub: 'lu',
  lug: 'lg',
  mah: 'mh',
  mal: 'ml',
  mar: 'mr',
  omr: 'mr',
  mkd: 'mk',
  xmk: 'mk',
  bhr: 'mg',
  bmm: 'mg',
  bzc: 'mg',
  mlg: 'mg',
  msh: 'mg',
  plt: 'mg',
  skg: 'mg',
  tdx: 'mg',
  tkg: 'mg',
  txy: 'mg',
  xmv: 'mg',
  xmw: 'mg',
  mdl: 'mt',
  mlt: 'mt',
  cmg: 'mn',
  khk: 'mn',
  mon: 'mn',
  msr: 'mn',
  mvf: 'mn',
  xng: 'mn',
  mri: 'mi',
  msa: 'ms',
  mya: 'my',
  obr: 'my',
  nau: 'na',
  nav: 'nv',
  nbl: 'nr',
  nde: 'nd',
  ndo: 'ng',
  nep: 'ne',
  brc: 'nl',
  dse: 'nl',
  dum: 'nl',
  nld: 'nl',
  odt: 'nl',
  skw: 'nl',
  nno: 'no',
  nob: 'no',
  nor: 'no',
  nsl: 'no',
  rmg: 'no',
  nya: 'ny',
  oci: 'oc',
  ojb: 'oj',
  ojc: 'oj',
  ojg: 'oj',
  oji: 'oj',
  ojs: 'oj',
  ojw: 'oj',
  ori: 'or',
  gax: 'om',
  gaz: 'om',
  hae: 'om',
  orm: 'om',
  oss: 'os',
  pan: 'pa',
  pnb: 'pa',
  pcf: 'pi',
  pli: 'pi',
  plu: 'pi',
  pol: 'pl',
  pso: 'pl',
  idb: 'pt',
  mcm: 'pt',
  por: 'pt',
  psr: 'pt',
  vkp: 'pt',
  pus: 'ps',
  qub: 'qu',
  que: 'qu',
  quf: 'qu',
  quh: 'qu',
  quk: 'qu',
  qul: 'qu',
  qup: 'qu',
  qur: 'qu',
  qux: 'qu',
  quy: 'qu',
  quz: 'qu',
  qva: 'qu',
  qvc: 'qu',
  qve: 'qu',
  qvh: 'qu',
  qvl: 'qu',
  qvm: 'qu',
  qvn: 'qu',
  qvo: 'qu',
  qvp: 'qu',
  qvs: 'qu',
  qvw: 'qu',
  qwa: 'qu',
  qwc: 'qu',
  qwh: 'qu',
  qws: 'qu',
  qxa: 'qu',
  qxc: 'qu',
  qxh: 'qu',
  qxn: 'qu',
  qxo: 'qu',
  qxp: 'qu',
  qxt: 'qu',
  qxu: 'qu',
  qxw: 'qu',
  roh: 'rm',
  rms: 'ro',
  ron: 'ro',
  ruo: 'ro',
  rup: 'ro',
  ruq: 'ro',
  run: 'rn',
  orv: 'ru',
  rsl: 'ru',
  rus: 'ru',
  sag: 'sg',
  snj: 'sg',
  san: 'sa',
  sin: 'si',
  slk: 'sk',
  svk: 'sk',
  slv: 'sl',
  sme: 'se',
  smo: 'sm',
  sna: 'sn',
  sbn: 'sd',
  snd: 'sd',
  som: 'so',
  sot: 'st',
  osp: 'es',
  spa: 'es',
  spq: 'es',
  ssp: 'es',
  aae: 'sq',
  aat: 'sq',
  aln: 'sq',
  als: 'sq',
  sqi: 'sq',
  sqk: 'sq',
  sdc: 'sc',
  sdn: 'sc',
  src: 'sc',
  srd: 'sc',
  sro: 'sc',
  rsb: 'sr',
  srp: 'sr',
  ssw: 'ss',
  sun: 'su',
  swa: 'sw',
  fss: 'sv',
  swe: 'sv',
  swl: 'sv',
  tah: 'ty',
  oty: 'ta',
  tam: 'ta',
  crh: 'tt',
  sty: 'tt',
  tat: 'tt',
  tel: 'te',
  tgk: 'tg',
  tgl: 'tl',
  cth: 'th',
  nod: 'th',
  pht: 'th',
  soa: 'th',
  sou: 'th',
  tha: 'th',
  tsq: 'th',
  tts: 'th',
  tir: 'ti',
  ton: 'to',
  tsn: 'tn',
  tso: 'ts',
  tuk: 'tk',
  bgx: 'tr',
  kmz: 'tr',
  ota: 'tr',
  otk: 'tr',
  tsm: 'tr',
  tur: 'tr',
  twi: 'tw',
  oui: 'ug',
  uig: 'ug',
  ukl: 'uk',
  ukr: 'uk',
  urd: 'ur',
  uzb: 'uz',
  uzn: 'uz',
  uzs: 'uz',
  ven: 've',
  vie: 'vi',
  vol: 'vo',
  wln: 'wa',
  wof: 'wo',
  wol: 'wo',
  xho: 'xh',
  ydd: 'yi',
  yid: 'yi',
  yih: 'yi',
  yor: 'yo',
  zch: 'za',
  zeh: 'za',
  zgb: 'za',
  zgm: 'za',
  zgn: 'za',
  zha: 'za',
  zhd: 'za',
  zhn: 'za',
  zlj: 'za',
  zln: 'za',
  zlq: 'za',
  zqe: 'za',
  zyb: 'za',
  zyg: 'za',
  zyj: 'za',
  zyn: 'za',
  zzj: 'za',
  cdo: 'zh',
  cjy: 'zh',
  cmn: 'zh',
  cnp: 'zh',
  cpx: 'zh',
  csl: 'zh',
  csp: 'zh',
  czh: 'zh',
  czo: 'zh',
  gan: 'zh',
  hak: 'zh',
  hsn: 'zh',
  ltc: 'zh',
  lzh: 'zh',
  mnp: 'zh',
  nan: 'zh',
  och: 'zh',
  wuu: 'zh',
  yue: 'zh',
  zho: 'zh',
  zul: 'zu'
}
