# -*- coding: utf-8 -*-
from setuphelpers import *

appx_package_name = "MSTeams"
appx_dir = makepath(systemdrive, programfiles, "Teams", "MSTeams-arm64.msix")
bin_exe = "teamsbootstrapper.exe"


def install():
    # Declare local variables
    os_name = host_info()['os_name']
    bin_path = glob.glob(f"{appx_package_name}*.msix")[0]
    bin_exe = glob.glob("teamsbootstrapper.exe")[0]

    mkdirs(makepath(systemdrive, programfiles, "Teams"))
    filecopyto(bin_path, appx_dir)

    # Remove old versions
    print(f"Removing AppX: {appx_package_name}")
    run_powershell('Get-AppXProvisionedPackage -Online | Where-Object DisplayName -Like "*Teams*" | Remove-AppxProvisionedPackage -Online')
    run_powershell('Get-AppxPackage -AllUsers | Where-Object Name -like "*Teams*" | Remove-AppxPackage -AllUsers')

    print(f"Installation of {appx_package_name}")
    killalltasks(ensure_list(control.impacted_process))
    if 'Enterprise LTSC' in os_name:
        registry_setstring(HKEY_LOCAL_MACHINE, 'SOFTWARE\\Policies\\Microsoft\\Windows\\Appx', 'AllowAllTrustedApps', 1, type=REG_DWORD)
        run_powershell(f'Add-AppxProvisionedPackage -Online -PackagePath "{bin_path}" -SkipLicense')
    else:
        run(f'"{bin_exe}" -p -o "{appx_dir}"')
    
    # Copy of exe in persistent location of this package
    filecopyto(bin_exe, makepath(persistent_dir, bin_exe))


def uninstall():
    print(f"Removing AppX: {appx_package_name}")

    run_powershell('Get-AppXProvisionedPackage -Online | Where-Object DisplayName -Like "*Teams*" | Remove-AppxProvisionedPackage -Online')
    run_powershell('Get-AppxPackage -AllUsers | Where-Object Name -like "*Teams*" | Remove-AppxPackage -AllUsers')

    teamsbootstrapper_path = makepath(persistent_dir, bin_exe)

    run(f'"{teamsbootstrapper_path}" -x')

    # Waiting a minute to not trigger LUTI error Access denied on teamsbootstrapper.exe
    time.sleep(60)

    if isdir(makepath(programfiles, "Teams")):
        remove_tree(makepath(programfiles,"Teams"))

    if isfile(teamsbootstrapper_path):
        remove_file(teamsbootstrapper_path)


def audit():
    # Declaring local variables
    appxprovisionedpackage = run_powershell(f'Get-AppXProvisionedPackage -Online | Where-Object DisplayName -Like "{appx_package_name}"')

    # Auditing software
    if appxprovisionedpackage is None:
        print(f"{appx_package_name} is not installed.")
        return "ERROR"
    
    if Version(appxprovisionedpackage.get("Version", "0"), 4) < Version(control.get_software_version(), 4):
        print(f'{appxprovisionedpackage["PackageName"]} is installed in version: {appxprovisionedpackage["Version"]} instead of: {control.get_software_version()}.')
        return "WARNING"

    print(f'{appxprovisionedpackage["PackageName"]} is installed and up-to-date.')
    return "OK"