# -*- coding: utf-8 -*-
from setuphelpers import *

appx_package_name = "MSTeams"
appx_dir = makepath(systemdrive,programfiles, "Teams", "MSTeams-x64.msix")
bin_exe = "teamsbootstrapper.exe"

def get_persistent_package_file(bin_exe):
    if isdir(makepath(os.getcwd(), "WAPT", "persistent")):
        return makepath(os.getcwd(), "WAPT", "persistent", bin_exe)
    else:
        return makepath(WAPT.persistent_root_dir, control.package_uuid, bin_exe)

def install():
    # Declare local variables
    bin_path = glob.glob(f"{appx_package_name}*.msix")[0]
    mkdirs(makepath(systemdrive,programfiles,"Teams"))
    
    filecopyto(bin_path, appx_dir)
    bin_exe = glob.glob("teamsbootstrapper.exe")[0]

    # Allow sideloading to enable install on Windows 11 LTSC
    osname = host_info()['os_name']
    if 'Enterprise LTSC' in osname:
        registry_setstring(HKEY_LOCAL_MACHINE, 'SOFTWARE\\Policies\\Microsoft\\Windows\\Appx', 'AllowAllTrustedApps', 1, type=REG_DWORD)

    # Remove old versions 
    appxprovisionedpackage = run_powershell(f'Get-AppXProvisionedPackage -Online | Where-Object DisplayName -Like "{appx_package_name}"')
    if appxprovisionedpackage is None:
        remove_appx(appx_package_name, False)
        appxprovisionedpackage = {"Version": "0"}
    elif force:
        uninstall()
        
    run_powershell(f'Add-AppxProvisionedPackage -Online -PackagePath "{bin_path}" -SkipLicense')
    
    # Copy of exe in persistent location of this package
    filecopyto(bin_exe, get_persistent_package_file(bin_exe))


def uninstall():
    print(f"Removing AppX: {appx_package_name}")
    remove_appx(appx_package_name)
    run(f'"{get_persistent_package_file(bin_exe)}" -x')
    if isdir(makepath(programfiles,"Teams")):
        remove_tree(makepath(programfiles,"Teams"))


def audit():
    # Declaring local variables
    audit_result = "OK"
    audit_version = True
    appxprovisionedpackage = run_powershell(f'Get-AppXProvisionedPackage -Online | Where-Object DisplayName -Like "{appx_package_name}"')

    # Auditing software
    if appxprovisionedpackage is None:
        print(f"{appx_package_name} is not installed.")
        audit_result = "ERROR"
    elif audit_version:
        if Version(appxprovisionedpackage.get("Version", "0"), 4) < Version(control.get_software_version(), 4):
            print(
                f'{appxprovisionedpackage["PackageName"]} is installed in version: {appxprovisionedpackage["Version"]} instead of: {control.get_software_version()}.'
            )
            audit_result = "WARNING"
        else:
            print(f'{appxprovisionedpackage["PackageName"]} is installed and up-to-date.')
    else:
        print(f'{appxprovisionedpackage["PackageName"]} is installed.')

    return audit_result


def remove_appx(package, default_user=True):
    """Remove Windows AppX package from the computer environment, excluding NonRemovable packages.

    Args:
        package (str): AppX package name. You can use an asterisk (*) as a wildcard.
        default_user (bool): Remove AppX package from the Windows image to prevent installation for new users.

    .. versionchanged:: 2.5
        No longer try to remove NonRemovable AppX package

    .. versionchanger:: 2.6
        No longer use run_powershell for uninstall
    """
    
    if running_as_admin() or running_as_system():
        if default_user:
            ps_script = f'Get-AppXProvisionedPackage -Online | Where-Object DisplayName -Like ""{package}"" | Remove-AppxProvisionedPackage -Online -AllUsers'
            run_powershell_script(ps_script, output_format="text")

        ps_script = f'Get-AppxPackage -Name ""{package}"" -AllUsers | Where-Object -property NonRemovable -notlike True | Remove-AppxPackage -AllUsers'
        run_powershell_script(ps_script, output_format="text")

    else:
        ps_script = f'Get-AppxPackage -Name ""{package}"" | Where-Object -property NonRemovable -notlike True | Remove-AppxPackage'
        run_powershell_script(ps_script, output_format="text")