# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    download_dict = {
        "windows-x64": "https://statics.teams.cdn.office.net/production-windows-x64/enterprise/webview2/lkg/MSTeams-x64.msix",
        "windows-x86": "https://statics.teams.cdn.office.net/production-windows-x86/enterprise/webview2/lkg/MSTeams-x86.msix",
        "windows-arm64": "https://statics.teams.cdn.office.net/production-windows-arm64/enterprise/webview2/lkg/MSTeams-arm64.msix",
    }
    exe_url = "https://statics.teams.cdn.office.net/production-teamsprovision/lkg/teamsbootstrapper.exe"
    exe_bin = exe_url.split("/")[-1]
    download_url = download_dict[control.target_os + "-" + ensure_list(control.architecture)[0]]
    latest_bin = download_url.split("/")[-1]


    # Deleting binaries
    remove_file(latest_bin)

    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    if not isfile(exe_bin):
        print("Downloading: %s" % exe_bin)
        wget(exe_url, exe_bin,proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Checking version from file
    if get_os_name() == "Windows" and "windows" in control.target_os.lower():
        version_bin = unzip(latest_bin, ".", "ms-teams.exe")[0]
        version = get_version_from_binary(version_bin)
        remove_file((version_bin))
    else:
        version = control.get_software_version()

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return package_updated

    # # Changing version of the package and validating update-package-sources
    # return complete_control_version(control, version)
