# -*- coding: utf-8 -*-
from setuphelpers import *

# Important: Beginning January 1, 2022, we are ending support for selected OneDrive desktop apps running on Windows 7, 8, and 8.1. Learn more.
def install():
    # Declaring local variables
    bin_name = glob.glob("*OneDriveSetup*.exe")[0]
    session_setup()
    # Installing the package
    print("Installing: %s" % bin_name)
    install_exe_if_needed(
        bin_name,
        silentflags="/allusers /silent",
        key="OneDriveSetup.exe",
        min_version=control.get_software_version(),
    )


def session_setup():
    # Declaring local variables
    task = r"\OneDrive Per-Machine Standalone Update Task"
    print("Disabling: auto-update-check")

    # Disabling application scheduled tasks
    if task_exists(task):
        try:
            disable_task(task)
        except:
            print("Unable to disable the task: %s" % task)
