# -*- coding: utf-8 -*-
from setuphelpers import *
import json

def update_package():
    proxies = {}
    if isfile(makepath(application_data(),'waptconsole','waptconsole.ini')):
        proxywapt = inifile_readstring(makepath(user_local_appdata(),'waptconsole','waptconsole.ini'),'global','http_proxy')
        if proxywapt :
            proxies = {'http':proxywapt,'https':proxywapt}

    version = json.loads(wgets('https://api.github.com/repos/mattermost/mattermost-server/releases/latest',proxies=proxies))['name'][1:]
    filename = 'mattermost-%s-linux-amd64.tar.gz' % version
    url = 'https://releases.mattermost.com/%s/mattermost-%s-linux-amd64.tar.gz' % (version,version)

    for fileexe in glob.glob('mattermost-*-linux-amd64.tar.gz'):
        if fileexe != filename :
            print('Delete ' + fileexe)
            remove_file(fileexe)

    if not isfile(filename):
        print('Download ' + url)
        wget(url,filename,proxies=proxies,verify_cert=False)
    else:
        print('Skip - %s already exist' % filename)

    control.version = version + '-0'
    control.save_control_to_wapt(os.getcwd())