# -*- coding: utf-8 -*-
from setuphelpers import *

# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
bin_contains = "MathGraph32JS"
silentflags = "/VERYSILENT /SUPPRESSMSGBOXES /NORESTART"
app_uninstallkey = "{31BC28F5-98A9-4C4F-828E-22F937C4E349}_is1"

def versmathgrap32(key):
    return get_version_from_binary(glob.glob("%s*.exe" % key["install_location"])[0])

def install():
    # Declaring local variables
    package_version = control.get_software_version()
    zip_name = glob.glob("*%s*.zip" % bin_contains)[0]
    unzip(zip_name,target='.')
    bin_name = glob.glob("*%s*.exe" % bin_contains)[0]

    # Remove old version
    for oldmathgraph32 in installed_softwares("MathGraph32 Java"):
        run(uninstall_cmd(oldmathgraph32["key"]))

    print("installing mathgraph32")
    for soft in installed_softwares(app_uninstallkey):
        if "32 bit" in soft["name"]:
            run(uninstall_cmd(app_uninstallkey))

    # Install
    install_exe_if_needed(
        bin_name,
        silentflags,
        key=app_uninstallkey,
        min_version=package_version,
        get_version=versmathgrap32,
    )
    register_uninstall(uninstallkey=app_uninstallkey,display_version=package_version)
    remove_desktop_shortcut("MathGraph32JS")

