# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    
    base_url_download = "https://lmstudio.ai/download/latest"
    os_download_dict = {
        'windows-x64': '/win32/x64',
        'windows-arm64': '/win32/arm64',
        'darwin-arm': '/darwin/arm64',
        'linux-x64': '/linux/x64',
        'linux-arm64': '/linux/arm64',
    }

    os_type = control.target_os + "-" + ensure_list(control.architecture)[0]
    download_url = requests.head(f"{base_url_download}{os_download_dict[os_type]}", proxies=proxies).headers['Location']
    latest_bin = download_url.rsplit('/', 1)[-1]
    latest_bin_extension = latest_bin.rsplit('.', 1)[-1]
    version = latest_bin.split('-')[2]

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated