# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *



def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    dict_arch = {"x64":"-win64.exe", "x86":"-win32.exe"}    
    url_api = "https://api.github.com/repos/llvm/llvm-project/releases/latest"

    print("API used is: %s" % url_api)
    json_load = wgets(url_api, proxies=proxies, as_json=True)

    for download in json_load["assets"]:
        if dict_arch[control.architecture] in download["name"]:
            download_url = download["browser_download_url"]
            version = download["name"].split('-')[-2]
            latest_bin = download["name"]
            latest_bin_extension = latest_bin.rsplit('.', 1)[-1]
            break
    
    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated