# -*- coding: utf-8 -*-
from setuphelpers import *
import re

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()
 {
   "key":"{56C1065D-3523-4025-B76D-6F73F67F7F93}_is1",
   "name":"Lidarr version 2.4.0",
   "version":"2.4.0",
   "install_date":"2024-06-24 00:00:00",
   "install_location":"C:\\ProgramData\\Lidarr\\",
   "uninstall_string":"\"C:\\ProgramData\\Lidarr\\unins000.exe\"",
   "publisher":"Team Lidarr",
   "system_component":0,
   "win64":false
  }

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():
    # Declaring local variables
    installer_files = glob.glob('Lidarr.*.windows-core-x64-installer.exe')
    if not installer_files:
        raise FileNotFoundError("No installer files found matching the pattern 'Lidarr.*.windows-core-x64-installer.exe'")
    
    bin_name = installer_files[0]
    
    # Extracting version from the filename using regex
    match = re.search(r'Lidarr\.[\w.]+\.(\d+\.\d+\.\d+\.\d+)\.windows-core-x64-installer\.exe', bin_name)
    if not match:
        raise ValueError(f"Filename {bin_name} does not match expected pattern for extracting version")
    
    version = match.group(1)
    
    # Logging the extracted version for debugging purposes
    print(f"Extracted version from filename: {version}")
    
    # Installing the software
    install_exe_if_needed(
        bin_name,
        silentflags='/VERYSILENT /SUPPRESSMSGBOXES /NORESTART /SP-',
        key='{56C1065D-3523-4025-B76D-6F73F67F7F93}_is1',
        min_version=control.get_software_version(),
        get_version=lambda _: version,  # Lambda function that returns the extracted version
        timeout=600,
    )

# Function to set the version in the registry after installation
def get_version(app_registry_dict):
    # Return the default version if not found to force installation
    return app_registry_dict.get("version", "0.0.0.0")