# -*- coding: utf-8 -*-
from setuphelpers import *
import requests


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    url = "https://www.libreoffice.org/download/download"
    if control.architecture == "x64":
        dl_arch = "x86_64"
        ends_bin_name = "_Win_x86-64.msi"
    else:
        dl_arch = "x86"
        ends_bin_name = "_Win_x86.msi"

    # Getting latest version from official website
    version = bs_find_all(url, "span", "class", "dl_version_number", proxies=proxies)[0 if "fresh" in control.package else 1].text
    search_url = "https://download.documentfoundation.org/libreoffice/stable/%s/win/%s/" % (version, dl_arch)
    latest_bin = "LibreOffice_" + version + ends_bin_name
    download_url = search_url + latest_bin
    if requests.head(download_url, proxies=proxies).status_code == 404:
        latest_bin = "LibreOffice_" + version + "_Win_x86-64.msi"
        download_url = search_url + latest_bin

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Checking version from file
    version_from_file = get_version_from_binary(latest_bin)
    if Version(version_from_file, 3) != Version(version, 3) and version_from_file != "":
        print("Changing version to the version number of the binary (from: %s to: %s)" % (version, version_from_file))
        # os.rename(latest_bin, latest_bin.replace(version, version_from_file))
        version = version_from_file
    else:
        print("Binary file version corresponds to online version")

    # Changing version of the package
    version = ".".join(version.split(".")[:3])
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Validating or not update-package-sources
    return package_updated
