# -*- coding: utf-8 -*-
from setuphelpers import *
import winreg

# Installation procedure: https://wiki.documentfoundation.org/Deployment_and_Migration
# Consider LBO as Collabora Office if relevant
silent_args_dict = {
    "ALLUSERS": 1,
    "CREATEDESKTOPLINK": 1,
    "REBOOTYESNO": "No",
    "ISCHECKFORPRODUCTUPDATES": 0,
    "VC_REDIST": 0,
    "QUICKSTART": 0,
    "ADDLOCAL": "ALL",
}
# To auto detect if LBO should be set as default Office applications make sure both following parameters are set to False
force_register_as_default_mso_app = False  # Make sure that LBO will BE the default application for any Office applications
force_no_register_as_default_mso_app = True  # Make sure that LBO will NOT BE the default application for any Office applications


def install():
    # Declaring local variables
    bin_name = glob.glob("*Office_*.msi")[0]
    if "libreoffice" in control.package:
        silent_args_dict.update({"REMOVE": "gm_o_Onlineupdate"})

    """
    REGISTER_ALL_MSO_TYPES (default=0) - use LibreOffice as the default application for Microsoft Office file formats 
    REGISTER_NO_MSO_TYPES  (default=0) - don't use LibreOffice as default application for any Microsoft Office file formats 
    REGISTER_DOC           (default=0) - use LibreOffice as the default application for Microsoft Word file format .doc (You can use similar for .xls, .ppt etc.)
    """
    # Defining Office default applications
    if force_register_as_default_mso_app == force_no_register_as_default_mso_app:
        # Checking if MSO file extensions refer to MSO apps and affect LBO if not
        if not get_file_assocation(".doc").startswith("Word") and not get_file_assocation(".docx").startswith("Word"):
            silent_args_dict["REGISTER_DOC"] = 1
            silent_args_dict["REGISTER_DOCX"] = 1
        if not get_file_assocation(".xls").startswith("Excel") and not get_file_assocation(".xlsx").startswith("Excel"):
            silent_args_dict["REGISTER_XLS"] = 1
            silent_args_dict["REGISTER_XLSX"] = 1
        if not get_file_assocation(".ppt").startswith("PowerPoint") and not get_file_assocation(".pptx").startswith("PowerPoint"):
            silent_args_dict["REGISTER_PPT"] = 1
            silent_args_dict["REGISTER_PPTX"] = 1
        if not get_file_assocation(".pub").startswith("Publisher"):
            silent_args_dict["REGISTER_PUB"] = 1

        # Checking if a version of MSO is installed
        count_mso_apps = 0
        if installed_softwares(name="Microsoft Office "):
            count_mso_apps += 1
        if installed_softwares(name="Office 365"):
            count_mso_apps += 1
        if installed_softwares(name="Microsoft 365"):
            count_mso_apps += 1

        if count_mso_apps == 0:
            # Register LBO as default MSO apps if no MSO version was detected
            silent_args_dict["REGISTER_ALL_MSO_TYPES"] = 1
        else:
            # Do not register LBO as default MSO apps since a MSO version was detected
            silent_args_dict["REGISTER_NO_MSO_TYPES"] = 1

    else:
        if force_register_as_default_mso_app:
            # Register LBO as default MSO apps
            silent_args_dict["REGISTER_ALL_MSO_TYPES"] = 1
        elif force_no_register_as_default_mso_app:
            # Do not register LBO as default MSO apps
            silent_args_dict["REGISTER_NO_MSO_TYPES"] = 1

    # Installing the software
    if silent_args_dict.get("REGISTER_ALL_MSO_TYPES"):
        print("REGISTER_ALL_MSO_TYPES")
    elif silent_args_dict.get("REGISTER_NO_MSO_TYPES"):
        print("REGISTER_NO_MSO_TYPES")
    else:
        print("No parameter detected for REGISTER_MSO_TYPES")
    install_msi_if_needed(
        bin_name,
        properties=silent_args_dict,
        timeout=1200,
    )
    source_file = makepath(basedir,"no_update.xcd")
    destination_file = makepath(programfiles,"LibreOffice","share","registry","no_update.xcd")
    filecopyto(source_file,destination_file)

def uninstall():
    config_file = makepath(programfiles,"LibreOffice","share","registry","no_update.xcd")
    if isfile(config_file):
        remove_file(config_file)


def get_file_assocation(ext):
    r"""Return the associated application for a file extension (example : '.doc')

    >>> get_file_assocation('.pptx')
    'LibreOffice.Pptx'

    """
    try:
        return winreg.QueryValue(winreg.HKEY_CLASSES_ROOT, ext)
    except:
        return ""
