# -*- coding: utf-8 -*-
from setuphelpers import *
import tarfile
from typing import List, Optional


app_name = "lazygit"
bin_name = "lazygit"
bin_path = "/usr/local/bin"
app_path = makepath("/opt", app_name)

bin_target = makepath(bin_path, bin_name)
app_target = makepath(app_path, bin_name)

def install():
    extract_path = glob.glob("lazygit_*_linux_arm64.tar.gz")[0]
    mkdirs(app_path)
    extract_tar(extract_path, app_path)
    
    if isfile(bin_target):
        remove_file(bin_target)

    os.symlink(app_target, bin_target)

def uninstall():
    print(f"Removing {app_name}")
    if isfile(bin_target):
        remove_file(bin_target)
    if isdir(app_path):
        remove_tree(app_path)

def extract_tar(
    tar_path: str,
    extract_path: str = ".",
    exclude_list: Optional[List[str]] = None,
    include_list: Optional[List[str]] = None
) -> None:
    """
    Extracts a tar archive to the given directory, with optional inclusion or exclusion filtering.

    :param tar_path: Path to the .tar (or .tar.gz, .tar.bz2, etc.) archive.
    :param extract_path: Directory where files should be extracted.
    :param exclude_list: List of path prefixes to exclude from extraction.
    :param include_list: List of path prefixes to include exclusively. Overrides exclude_list if provided.
    """
    with tarfile.open(tar_path, 'r:*') as tar:
        all_members = tar.getmembers()

        if include_list:
            include_set = set(include_list)
            members = [
                m for m in all_members
                if any(m.name.startswith(inc) for inc in include_set)
            ]
        elif exclude_list:
            exclude_set = set(exclude_list)
            members = [
                m for m in all_members
                if not any(m.name.startswith(exc) for exc in exclude_set)
            ]
        else:
            members = all_members

        tar.extractall(path=extract_path, members=members)