# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import glob
import requests
import os

def get_headers(url, proxies=None):
    response = requests.head(url, allow_redirects=True, proxies=proxies)
    return response.headers

def update_package():
    # Declaring local variables
    package_updated = False
    
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()

    url_base = "https://download.cloud.lastpass.com/windows_installer/LastPassInstaller.msi"
    latest_bin = "LastPassInstaller.msi"
    headers_file = "last_headers.txt"

    # Get current headers from the URL
    current_headers = get_headers(url_base, proxies)
    current_etag = current_headers.get('ETag')
    current_last_modified = current_headers.get('Last-Modified')

    # Load previous headers
    previous_etag = None
    previous_last_modified = None

    if os.path.isfile(headers_file):
        with open(headers_file, 'r') as f:
            previous_etag = f.readline().strip()
            previous_last_modified = f.readline().strip()

    # Check if there is an update
    download_url = url_base
    if (current_etag and current_etag != previous_etag) or (current_last_modified and current_last_modified != previous_last_modified):
        print("A new version is available. Downloading the latest version.")
        package_updated = True
    elif not os.path.isfile(latest_bin):
        print("File does not exist locally. Downloading the file.")
        package_updated = True
    else:
        print("The current version is up to date. No need to download.")

    # Downloading latest binaries if needed
    if package_updated:
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)

        # Save the current headers for future comparison
        with open(headers_file, 'w') as f:
            if current_etag:
                f.write(current_etag + '\n')
            if current_last_modified:
                f.write(current_last_modified + '\n')

    # Delete outdated binaries
    for f in glob.glob('*.msi'):
        if f != latest_bin:
            remove_file(f)

    # Update the package if there is a new version
    version = get_version_from_binary(latest_bin)
    control.set_software_version(version)
    control.save_control_to_wapt() 

