# -*- coding: utf-8 -*-
from setuphelpers import *


def install():
    for to_uninstall in installed_softwares("Laragon_is1"):
        version = to_uninstall["version"]
        if Version(version, 4) < Version(control.get_software_version(), 4) or force:
            print("Removing: %s (%s)" % (to_uninstall["name"], version))
            killalltasks(ensure_list(control.impacted_process))
            run(uninstall_cmd(to_uninstall["key"]))
            wait_uninstallkey_absent(to_uninstall["key"])

    bin_name = glob.glob("laragon-wamp.exe")[0]
    install_exe_if_needed(
        bin_name,
        silentflags="/allusers /VERYSILENT",
        key="Laragon_is1",
        get_version=get_version,
        min_version=control.get_software_version(),
    )


def get_version(app_registry_dict):
    return app_registry_dict["version"].rsplit(".", 1)[0]
