# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Initializing variables
    bin_name_string = "krita-x64-%s-setup.exe"
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    url = "https://krita.org/en/download/"
    bin_end = bin_name_string.split("%s")[-1]
    # bin_start = bin_name_string.split('%s')[0]

    # Getting latest version from official sources
    print("URL used is: %s" % url)
    for bs_search in bs_find_all(url, "a", "id", "windows-download", proxies=proxies):
        if bs_search["href"].split("/")[-1].endswith(bin_end):
            version = bs_search["href"].split("/")[-2]
            latest_bin = bs_search["href"].split("/")[-1]
            url_dl = bs_search["href"]
            break

    print("Latest %s version is: %s" % (app_name, version))
    print("Download url is: %s" % url_dl)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(url_dl, latest_bin, proxies=proxies)

        # Checking version from file
        version_from_file = get_version_from_binary(latest_bin)
        # if not version_from_file.startswith(version) and version_from_file != '':
        if Version(version_from_file) != Version(version) and version_from_file != "":
            print("Changing version to the version number of the binary")
            os.rename(latest_bin, latest_bin.replace(version, version_from_file))
            version = version_from_file
        else:
            print("Binary file version corresponds to online version")

        # Changing version of the package
        control.version = "%s-%s" % (version, int(control.version.split("-")[-1]) + 1)
        control.save_control_to_wapt()
        print("Changing package version to: %s in WAPT\\control" % control.version)

    # Deleting outdated binaries
    remove_outdated_binaries(version)
