# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Initializing variables
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    url = "https://krita.org/en/download/"

    # Getting latest version from official sources
    print("URL used is: %s" % url)
    for bs_search in bs_find_all(url, "a", "id", "macOS-download", proxies=proxies):
        if bs_search["href"].split("/")[-1].endswith(".dmg"):
            version = bs_search["href"].split("/")[-2]
            latest_bin = bs_search["href"].split("/")[-1]
            url_dl = bs_search["href"].replace("-release","")
            break

    print("Latest %s version is: %s" % (app_name, version))
    print("Download url is: %s" % url_dl)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(url_dl, latest_bin, proxies=proxies)

        # Changing version of the package
        control.version = "%s-%s" % (version, int(control.version.split("-")[-1]) + 1)
        control.save_control_to_wapt()
        print("Changing package version to: %s in WAPT\\control" % control.version)

    for f in glob.glob("*.dmg"):
        if f != latest_bin:
            remove_file(f)
