# -*- coding: utf-8 -*-
from setuphelpers import *

"""


"""


app_name = "k9s "
editor_dir = makepath(programfiles, "k9s")
app_dir = makepath(editor_dir, "k9s")
app_path = makepath(app_dir, "k9s.exe")
audit_version = False


def get_installed_version(app_path):
    return get_file_properties(app_path).get("FileVersion", "")


def install():
    # Declaring local variables
    zip_name = glob.glob(f"k9s_*.zip")[0]

    unzipped_dir = "k9s"


    # Installing software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir) and force:
        remove_tree(app_dir)
    mkdirs(app_dir)
    print("Extracting: %s to: %s" % (zip_name, unzipped_dir))
    unzip(zip_name, unzipped_dir)
    print('Copy k9s to %s' % app_dir)
    copytree2(unzipped_dir, app_dir, onreplace=default_overwrite)
    add_to_system_path(app_dir)
    

def audit():
    # Auditing software
    audit_status = "OK"
    installed_version = get_installed_version(app_path)
    if Version(installed_version) < Version(control.get_software_version()) and audit_version:
        print("%s is installed in version (%s) instead of (%s)" % (app_name, installed_version, control.get_software_version()))
        audit_status = "WARNING"
    elif isdir(app_dir) and not dir_is_empty(app_dir):
        print("%s (%s) is installed" % (app_name, installed_version))
        audit_status = "OK"
    else:
        print("%s is not installed" % app_name)
        audit_status = "ERROR"
    return audit_status


def uninstall():
    # Uninstalling software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir):
        remove_tree(app_dir)
    if dir_is_empty(editor_dir):
        remove_tree(editor_dir)

    

