# -*- coding: utf-8 -*-
##################################################
# This file is part of WAPT Enterprise
# All right reserved, (c) Tranquil IT Systems 2024
# For more information please refer to
# https://wapt.tranquil.it/store/licences.html
##################################################
from setuphelpers import *
from setupdevhelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    url = "https://codecguide.com/download_k-lite_codec_pack_mega.htm"

    # Getting latest version from official sources
    print("URL used is: %s" % url)
    for bs_search in bs_find_all(url, "h4", proxies=proxies):
        if "Version " in bs_search.text and " Mega ~ " in bs_search.text:
            version = bs_search.text.split(" ")[1]

    for bs_search in bs_find_all(url, "a", "href", proxies=proxies):
        # if bs_search["href"].endswith(bin_end):
        if "K-Lite_Codec_Pack_" in bs_search["href"] and "_Mega.exe" in bs_search["href"]:
            download_url = bs_search["href"]
            latest_bin = bs_search["href"].split("/")[-1]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Deleting outdated binaries
    remove_outdated_binaries(latest_bin)

    # Checking version from file
    if get_os_name() == "Windows" and "windows" in control.target_os.lower():
        version_from_file = get_version_from_binary(latest_bin)
        if Version(version_from_file, 4) == Version(version, 4):
            print(f"INFO: Binary file version ({version_from_file}) corresponds to online version ({version})")
        else:
            error(f"ERROR: Binary file version ({version_from_file}) do NOT corresponds to online version ({version})")

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating or not update-package-sources
    return package_updated
