# -*- coding: utf-8 -*-
from setuphelpers import *


app_name = "Julia"
app_dir = makepath(programfiles, app_name)
app_sys_path = makepath(app_dir, "bin")
app_path = makepath(app_sys_path, "julia.exe")
silentflags = f'/VERYSILENT /SUPPRESSMSGBOXES /NORESTART /ALLUSERS /DIR="{app_dir}"'
desktop_icon_path = makepath(desktop(True), "Julia.lnk")
program_menu_icon_path = makepath(programs(True), "Julia.lnk")


def install():
    # Declaring local variables
    bin_name = glob.glob("julia-*.exe")[0]
    app_uninstall_key = f"Julia-{control.get_software_version()}_is1"

    # Uninstalling portable version of the software
    if isdir(app_dir) and not installed_softwares(name="Julia "):
        remove_tree(app_dir)
        remove_from_system_path(makepath(programfiles, "julia", "bin"))

    # Uninstalling other versions of the software
    for to_uninstall in installed_softwares("Julia "):
        if Version(to_uninstall["version"]) != Version(control.get_software_version()) or force:
            print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
            killalltasks(ensure_list(control.impacted_process))
            run(uninstall_cmd(to_uninstall["key"]))
            wait_uninstallkey_absent(to_uninstall["key"])


    # Installing the software
    install_exe_if_needed(
        bin_name,
        silentflags=silentflags,
        key=app_uninstall_key,
        min_version=control.get_software_version(),
        timeout=600,
    )
    add_to_system_path(app_sys_path)

  # Changing desktop shortcuts
    remove_desktop_shortcut("Julia *")

    #Changing program menu shortcuts 
    remove_programs_menu_shortcut("Julia*", r"C:\ProgramData\Microsoft\Windows\Start Menu")
    create_programs_menu_shortcut("Julia.lnk", r"C:\Program Files\Julia\bin\julia.exe")



def uninstall():
    for to_uninstall in installed_softwares("Julia "):
        print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
        killalltasks(ensure_list(control.impacted_process))
        run(uninstall_cmd(to_uninstall["key"]))
        wait_uninstallkey_absent(to_uninstall["key"])

    remove_from_system_path(app_sys_path)
