# Jailer Database Tool

Jailer is a tool for database subsetting and relational data browsing.

 - The Subsetter creates small slices from your database (consistent and referentially intact)
   as SQL (topologically sorted), DbUnit records or XML.
   
   Ideal for creating small samples of test data or for local problem analysis with relevant production data.
   
 - The Data Browser lets you navigate through your database following the relationships (foreign key-based or user-defined) between tables.

<img src="/docs/screenshot.png" width="500" />

https://user-images.githubusercontent.com/861721/142761281-299bddc4-eea7-4f26-8c24-54fccb31b152.mp4

[More Videos](https://wisser.github.io/Jailer/videos.html)

## Features

 - Exports consistent and referentially intact row-sets from your productive database
   and imports the data into your development and test environment.
 - Improves database performance by removing and archiving obsolete data without violating integrity.
 - Generates topologically sorted SQL-DML, hierarchically structured JSON, YAML, XML and DbUnit datasets.
 - Data Browsing. Navigate bidirectionally through the database by following foreign-key-based or user-defined relationships.
 - SQL Console with code completion, syntax highlighting and database metadata visualization.
 - A demo database is included with which you can get a first impression without any configuration effort.

## Supported Databases

Thanks to the JDBC technology used, any DMBS is in principle supported. For best results, specific additional support features are useful, however. These are available for:

 - PostgreSQL
 - Oracle
 - MySQL
 - MariaDB
 - Microsoft SQL Server
 - IBM Db2
 - SQLite
 - Sybase
 - Amazon Redshift
 - Firebird
 - Informix Dynamic Server
 - H2
 - Exasol

## News

 - 2024-07-04    Data can now also be exported as structured JSON and YAML files.
 - 2024-06-26    A dark UI theme has been introduced that improves readability in low light environments.
 - 2024-04-18    DDL scripts for creating database objects can now be generated thanks to an integration of the [Liquibase](https://www.liquibase.com) tool. This makes it possible to create subset databases from scratch using only on-board means.
 - 2023-02-03    Thanks to deep analysis of statements, the SQL console can now relate the result of queries to the source tables and display them accordingly. In addition, this technique also allows filter conditions to be dynamically added to arbitrary SQL queries.
 - 2022-01-01    Comprehensive redesign and modernization of the entire user interface. New Look & Feel [FlatLaf](https://github.com/JFormDesigner/FlatLaf). 
 - 2021-02-04    Cycles in parent-child relationships will be detected and broken. Thus, such data can be exported by deferring the insertion of nullable foreign keys.
 - 2020-02-04    The Jailer engine is published in Maven repository. https://mvnrepository.com/artifact/io.github.wisser/jailer-engine
 - 2019-02-01    The new "Model Migration Tool" allows you to easily find and edit the newly added associations if the data model has been extended after the last change to this extraction model.
 - 2018-04-26    The new feature "Analyze SQL" analyzes SQL statements and proposes association definitions. This allows to reverse-engineer the data model based on existing SQL queries.
 - 2018-03-06    SQL Console with code completion, syntax highlighting and database metadata visualization.
 - 2017-05-10    New API provides programmatic access to the data export and import functionality. https://wisser.github.io/Jailer/api.html
 - 2017-03-30    Improved filter management. Templates allows you to define rules for assigning filters to columns. Filters on primary key columns will automatically be propagated to the corresponding foreign key columns. https://wisser.github.io/Jailer/filters.html
 - 2015-12-04    Data can now also be exported directly to a schema of the same database. This ensures optimal performance.
 - 2015-10-23    Rows can alternatively be collected in a separate embedded database. This allows exporting data from read-only databases.
 - 2014-07-20    Implemented the "Subset by Example" feature: Use the Data Browser to collect all the rows to be extracted and let Jailer create a model for that subset. https://wisser.github.io/Jailer/subset-by-example.html
 - 2014-04-15    A Data Browser has been introduced. Navigate bidirectionally through the database by following foreign-key-based or user-defined relationships.



## Installation

Use the installation file "Jailer-database-tools-n.n.n.msi" (for Windows) or "jailer-database-tools_n.n.n-x64.deb" (for Linux).

Unless you want to use your own Java installation. Or also if you want to use the command line interface (CLI). In this cases unzip the file "jailer_n.n.n.zip". See also <a href="https://wisser.github.io/Jailer/faq.html#multiuser">https://wisser.github.io/Jailer/faq.html#multiuser</a>

To start the tool from the unpacked zip:

  - On windows platform execute "Jailer.exe". You can also start "jailerGUI.bat".
  - On Unix/Linux/macOS platform execute the script "jailerGUI.sh" or use "java -jar jailer.jar"


## Building

Clone the git repository:

* `git clone https://github.com/Wisser/Jailer.git`

To build the tool you can just use ant: ( https://ant.apache.org )

* `cd Jailer`
* `ant`


## Contact
 - Home:    https://github.com/Wisser/Jailer or http://jailer.sourceforge.net/
 - Forum:   https://sourceforge.net/p/jailer/discussion/
 - Support: rwisser@users.sourceforge.net


## Contributors

### Code Contributors

This project exists thanks to all the people who contribute.
<a href="https://github.com/Wisser/Jailer/graphs/contributors"><img src="https://opencollective.com/Jailer/contributors.svg?width=890&button=false" /></a>

### Financial Contributors

Become a financial contributor and help us sustain our community. [[Contribute](https://opencollective.com/Jailer/contribute)]

#### Individuals

<a href="https://opencollective.com/Jailer"><img src="https://opencollective.com/Jailer/individuals.svg?width=890"></a>

#### Organizations

Support this project with your organization. Your logo will show up here with a link to your website. [[Contribute](https://opencollective.com/Jailer/contribute)]

<a href="https://opencollective.com/Jailer/organization/0/website"><img src="https://opencollective.com/Jailer/organization/0/avatar.svg"></a>
<a href="https://opencollective.com/Jailer/organization/1/website"><img src="https://opencollective.com/Jailer/organization/1/avatar.svg"></a>
<a href="https://opencollective.com/Jailer/organization/2/website"><img src="https://opencollective.com/Jailer/organization/2/avatar.svg"></a>
<a href="https://opencollective.com/Jailer/organization/3/website"><img src="https://opencollective.com/Jailer/organization/3/avatar.svg"></a>
<a href="https://opencollective.com/Jailer/organization/4/website"><img src="https://opencollective.com/Jailer/organization/4/avatar.svg"></a>
<a href="https://opencollective.com/Jailer/organization/5/website"><img src="https://opencollective.com/Jailer/organization/5/avatar.svg"></a>
<a href="https://opencollective.com/Jailer/organization/6/website"><img src="https://opencollective.com/Jailer/organization/6/avatar.svg"></a>
<a href="https://opencollective.com/Jailer/organization/7/website"><img src="https://opencollective.com/Jailer/organization/7/avatar.svg"></a>
<a href="https://opencollective.com/Jailer/organization/8/website"><img src="https://opencollective.com/Jailer/organization/8/avatar.svg"></a>
<a href="https://opencollective.com/Jailer/organization/9/website"><img src="https://opencollective.com/Jailer/organization/9/avatar.svg"></a>
