# -*- coding: utf-8 -*-
from setuphelpers import *
import sys
import subprocess
import os
import json

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():
    # Declaring local variables

    # Installing the software
    install_exe_if_needed('JabraDirectSetup.exe',
        silentflags='/install /quiet /norestart',
        name="^Jabra Direct$",
        min_version=control.get_software_version(),
    )

    for soft in installed_softwares('Jabra Direct'):
        if not soft['key'] in uninstallkey:
            uninstallkey.append(soft['key'])

def session_setup():
    # Declaring local variables
    jabra_app_folder = makepath(user_appdata, "Jabra Direct")
    config_json_file = makepath(jabra_app_folder, "jabradirectconfig.json")
    jabra_exe_link = makepath(programfiles32, "Jabra", "Direct6", "jabra-direct.exe")

    # Check if existing JSON
    if not isdir(jabra_app_folder) or not isfile(config_json_file):
        subprocess.Popen(jabra_exe_link, creationflags=subprocess.CREATE_NEW_CONSOLE)

    # Waiting JSON to be created
    timeout = 0
    while not os.path.exists(config_json_file):
        time.sleep(1)
        timeout+=1
        if timeout > 60:
            return

    # Remove update notifications
    time.sleep(60)
    with open(config_json_file) as file:
        data = json.load(file)

    data["DirectShowNotification"]["value"] = False
    data["DirectShowNotification"]["locked"] = True

    data["EnableFeedback"]["value"] = False
    data["EnableFeedback"]["locked"] = True

    # Change json file

    with open(config_json_file, "w") as file:
        json.dump(data, file)



