# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import glob


def update_package():
    # Declaration of local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    url_api = "https://jabraexpressonlinejdo.jabra.com/jdo/jdo.json"

    # Get data from API
    json_load = json.loads(wgets(url_api, proxies=proxies))
    windows_version = json_load["WindowsVersion"]
    windows_download_link = json_load["WindowsDownload"]
    filename = windows_download_link.split("/")[-1]
    
    for f in glob.glob('*.exe'):
        if get_file_properties(f)['ProductVersion'] != Version(windows_version):
            remove(f)  


    if not isfile(filename):
        package_updated = True
        wget(windows_download_link, filename, proxies=proxies)

    version = get_version_from_binary(filename)
    
    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))

    
    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated
