# -*- coding: utf-8 -*-
from setuphelpers import *
import glob


app_name = "Internxt"
app_dir = r"C:\Users\Administrator\AppData\Local\Programs\internxt-drive"


def install():
    # Trouver le premier fichier .exe dans le répertoire courant
    bin_name = glob.glob("*.exe")

    if not bin_name:
        raise FileNotFoundError("Aucun fichier .exe trouvé pour l'installation.")

    bin_name = bin_name[0]
    app_path = makepath(app_dir, bin_name)

    # Tuer tous les processus impactés avant l'installation
    killalltasks(ensure_list(control.impacted_process))

    # Supprimer l'installation existante si 'force' est vrai
    if isdir(app_dir) and force:
        remove_tree(app_dir)

    mkdirs(app_dir)
    filecopyto(bin_name, app_path)

    # Exécuter l'installateur avec le drapeau silencieux
    try:
        run(f'"{app_path}" /S')
    except Exception as e:
        print(f"Erreur lors de l'exécution de l'installateur : {e}")


def uninstall():
    # Killing any impacted processes before uninstallation
    killalltasks(ensure_list(control.impacted_process))

    # Command to uninstall internxt silently
    uninstall_cmd = r'"C:\Users\Administrator\AppData\Local\Programs\internxt-drive\Uninstall Uninstall Internxt Drive.exe" /S'

    try:
        # Attempt to run the uninstaller with the silent flag
        result = run(uninstall_cmd, accept_returncodes=[0, 3010, 1641])
        print(f"Uninstall command result: {result}")
    except Exception as e:
        print(f"Failed to uninstall internxt: {e}")

    if isdir(app_dir):
        remove_tree(app_dir)
