# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    try:
        import bs4 as BeautifulSoup
    except:
        import BeautifulSoup

    # Getting proxy informations from WAPT settings
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    urlversion = "http://www.jrsoftware.org/isdl.php"
    page = wgets(urlversion, proxies=proxies)
    bs = BeautifulSoup.BeautifulSoup(page)

    bs_raw_string = str(bs.findAll("tr")[2]).split("innosetup-", 1)[1]
    version = bs_raw_string.split(".exe", 1)[0]

    url = "https://jrsoftware.org/download.php/is.exe"
    filename = f'innosetup-{version}.exe'

    for fileexe in glob.glob("*.exe"):
        if fileexe != filename:
            print("Delete " + fileexe)
            remove_file(fileexe)

    if not isfile(filename):
        print("Download " + url)
        wget(url, filename, proxies=proxies)

    control.version = version + "-11"
    control.save_control_to_wapt()
