# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import bs4 as BeautifulSoup


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    url = "https://inkscape.org/release/?latest=1"

    # Getting latest version from official website
    page = requests.get(url, proxies=proxies).text
    bs = BeautifulSoup.BeautifulSoup(page)

    bs_raw_string = bs.find("h2", text="Revisions")
    label = bs_raw_string.findNext().findNext()
    version = label.find("label").get_text(strip=True)

    os_dict = {
        'x64': f"https://inkscape.org/release/inkscape-{version}/mac-os-x/dmg/dl/",
        'arm': f"https://inkscape.org/release/inkscape-{version}/mac-os-x/dmg-arm64/dl/"
    }

    download_url = "https://inkscape.org/" + wgets(os_dict[control.architecture]).split(".dmg")[0].split("=")[-1] + ".dmg"
    latest_bin = download_url.rsplit('/', 1)[-1]
    latest_bin_extension = latest_bin.rsplit('.', 1)[-1]

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated