# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import requests


def update_package():
    # Déclaration des variables locales
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
      

    url = "https://sourceforge.net/projects/hwinfo/files/Windows_Installer/"
    response = requests.get(url)
    headers = bs_find_all(url,"th","headers")

    if headers:
        first_header = headers[0]
        a_tag = first_header.find("a")
        if a_tag:
            first_link = a_tag['href']
            version = first_link.split('/')[-2].rsplit('_')[-1].rsplit('.exe')[0]
            print(f"First version found: {version}")

     # Trouver tous les éléments <tr> avec la classe file et le titre correspondant à la version
    requet = requests.get(url + version).text
    rows = bs_find_all(requet, "tr",  class_name="file")
    target_title = f"hwi64_{version}.exe"
    
    latest_bin = target_title
    download_url = "https://freefr.dl.sourceforge.net/project/hwinfo/Windows_Installer/" + latest_bin

   
    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin,proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    #nettoyer les fichiers temporaires
    for f in glob.glob('*.exe'):
        if f != latest_bin:
            remove_file(f)

    version =get_version_from_binary(latest_bin)
    control.set_software_version(version)
    control.save_control_to_wapt()
    

    
