# -*- coding: utf-8 -*-
from setuphelpers import *
import time
import os.path


"""
{
    "key": "{2A6B6DA3-0A09-43E0-BBF1-B0A6EDBEE779}",
    "name": "HP Support Solutions Framework",
    "version": "12.18.34.21",
    "install_date": "2024-02-08 00:00:00",
    "install_location": "",
    "uninstall_string": "MsiExec.exe /X{2A6B6DA3-0A09-43E0-BBF1-B0A6EDBEE779}",
    "publisher": "HP Inc.",
    "system_component": 0,
    "win64": false,
},
{
    "key": "{54ECA61C-83AE-4EE3-A9F7-848155A33386}",
    "name": "HP Support Assistant",
    "version": "8.8.34.31",
    "install_date": "2024-02-08 00:00:00",
    "install_location": "C:\\Program Files (x86)\\Hewlett-Packard\\HP Support Framework\\",
    "uninstall_string": '"C:\\Program Files (x86)\\InstallShield Installation Information\\{54ECA61C-83AE-4EE3-A9F7-848155A33386}\\setup.exe" -runfromtemp -l0x0409  -removeonly',
    "publisher": "HP Inc.",
    "system_component": 0,
    "win64": false,
}
HP Support Solutions Framework -- Cette application étant nécessaire à HP Support Assistant, elle ne peut être désinstallée.
MSI (s) (44:74) [12:04:46:751]: Windows Installer removed the product. Product Name: HP Support Solutions Framework. Product Version: 12.18.34.21. Product Language: 1036. Manufacturer: HP Inc.. Removal success or error status: 1603.

https://community.spiceworks.com/topic/2110039-is-it-possible-to-make-specific-changes-to-hp-assistant-using-gpo-s
https://silentinstallhq.com/hp-support-assistant-silent-install-how-to-guide/

"""


app_uninstallkey = "{54ECA61C-83AE-4EE3-A9F7-848155A33386}"


def install():
    bin_name = glob.glob("sp*.exe")[0]
    if isdir("sp"):
        remove_tree("sp")
    run(bin_name + " /s /e /f sp", accept_returncodes=[0, 1168, 3010])
    os.chdir("sp")

        # Adding QuietUninstallString
    quiet_uninstall_string = rf'"{programfiles32}\HP\HP Support Framework\UninstallHPSA.exe" /S /v/qn'
    register_uninstall(app_uninstallkey, quiet_uninstall_string, quiet_uninstall_string=quiet_uninstall_string, display_name=control.name)

    install_exe_if_needed(
        "InstallHPSA.exe",
        silentflags="/S /v/qn",
        min_version=control.get_software_version(),
    )

    # Debloating software
    if iswin64():
        reg_editor_path = r"SOFTWARE\WOW6432Node\Hewlett-Packard"
    else:
        reg_editor_path = r"SOFTWARE\WOW6432Node\Hewlett-Packard"
    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPHC"), "Install", "0")
    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPHC"), "Auto", "No")
    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPHC"), "CheckAll", "False")
    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPHC"), "FlagReset", "No")

    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPSF"), "HPUSchedule", 0)
    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPSF"), "ServicesEnabled", 0)
    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPSF"), "Startup", "No")
    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPSF"), "NotifyPopup", "0")
    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPSF"), "NotifyTray", "0")
    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPSF"), "NotifyServiceOffers", "0")
    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPSF"), "CIPOptin", "0")

    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPSF\Warranty"), "Optin", "0")

    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPSF\ContactOption"), "Cancel", "True")
    registry_set(HKEY_LOCAL_MACHINE, makepath(reg_editor_path, r"HPActiveSupport\HPSF\ContactOption"), "AnalysisStep", "0")

    # Disabling application scheduled tasks
    app_scheduled_tasks = [
        "\\Hewlett-Packard\\HP Web Products Detection",
        "\\Hewlett-Packard\\HPDeviceCheck",
        "\\Hewlett-Packard\\HP Support Assistant\\HP Support Assistant Quick Start",
        "\\Hewlett-Packard\\HP Support Assistant\\HP Support Solutions Framework Report",
        "\\Hewlett-Packard\\HP Support Assistant\\HP Support Solutions Framework Updater",
        r"\Hewlett-Packard\HP Support Assistant\HP Support Solutions Framework Updater - Resources"
        r"\Hewlett-Packard\HP Support Assistant\Opt-in For HP Support Assistant Quick Start"
        "\\Hewlett-Packard\\HP Support Assistant\\PC Health Analysis",
        "\\Hewlett-Packard\\HP Support Assistant\\Product Configurator",
    ]
    for task_name in app_scheduled_tasks:
        if task_exists(task_name):
            try:
                disable_task(task_name)
            except:
                print(f"Unable to disable the task_name: {task_name}")

    # Changing default start mode of the application services
    app_services = ["HPSupportSolutionsFrameworkService"]
    for service_name in app_services:
        set_service_start_mode(service_name, "Manual")





def uninstall():

    if params.get("install_with_luti", False):
        uninstall_path = makepath(programfiles32,"HP","HP Support Framework","UninstallHPSA.exe")
        nb_wait= 120
        while not os.path.exists(uninstall_path):
            nb_wait= nb_wait + 1
            if nb_wait > 120:
                break
            print("Uninstall not finded")
            time.sleep(1)

        if os.path.exists(uninstall_path):
            print("Uninstall finded, waiting install to finish")
            time.sleep(30)

    key = "{54ECA61C-83AE-4EE3-A9F7-848155A33386}"
    for to_uninstall in installed_softwares("HP Support "):
        if to_uninstall["name"] == "HP Support Assistant":
            print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
            killalltasks(ensure_list(control.impacted_process))
            run_notfatal(uninstall_cmd(to_uninstall["key"]))
            # unregister_uninstall(to_uninstall["app_uninstallkey"])
    for to_uninstall in installed_softwares("HP Support "):
        if to_uninstall["name"] == "HP Support Solutions Framework":
            print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
            killalltasks(ensure_list(control.impacted_process))
            run_notfatal(uninstall_cmd(to_uninstall["key"]))

    remove_empty_directories(makepath(programfiles32, "HP"))
    remove_empty_directories(makepath(programfiles32, "Hewlett-Packard"))

    reg_delete_path = r"SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall"
    registry_deletekey(HKEY_LOCAL_MACHINE, makepath(reg_delete_path), key)

    # editor_dir = makepath(programfiles32, "HP")
    # app_dir = makepath(editor_dir, "HP Support Framework")
    # if isdir(app_dir):
    #     remove_tree(app_dir)
    # if dir_is_empty(editor_dir):
    #     remove_tree(editor_dir)

    # editor_dir = makepath(programfiles32, "Hewlett-Packard")
    # app_dir = makepath(editor_dir, "HP Customer Feedback")
    # if isdir(app_dir):
    #     remove_tree(app_dir)
    # app_dir = makepath(editor_dir, "HP Support Framework")
    # if isdir(app_dir):
    #     remove_tree(app_dir)
    # app_dir = makepath(editor_dir, "HP Support Solutions")
    # if isdir(app_dir):
    #     remove_tree(app_dir)
    # if dir_is_empty(editor_dir):
    #     remove_tree(editor_dir)


def remove_empty_directories(root_directory):
    if os.path.exists(root_directory):
        for dirpath, dirnames, filenames in os.walk(root_directory, topdown=False):
            if not any(os.scandir(dirpath)):
                os.rmdir(dirpath)
                print(f"Removed empty directory: {dirpath}")
