# -*- coding: utf-8 -*-
from setuphelpers import *

def update_package():
    proxies = {}
    if isfile(makepath(application_data(), "waptconsole", "waptconsole.ini")):
        proxywapt = inifile_readstring(makepath(user_local_appdata(), "waptconsole", "waptconsole.ini"), "global", "http_proxy")
        if proxywapt:
            proxies = {"http": proxywapt, "https": proxywapt}

    lastestversion = wgets("https://www.hedgewars.org/download.html", proxies=proxies).split(".exe")[0].split("Hedgewars-")[-1]
    if not isfile("hedgewars-%s.exe" % lastestversion):
        wget("https://www.hedgewars.org/download/releases/Hedgewars-%s.exe" % lastestversion, "hedgewars-%s.exe" % lastestversion, proxies=proxies)

    for exe in glob.glob("*.exe"):
        if exe != "hedgewars-%s.exe" % lastestversion:
            remove_file(exe)

    pe = PackageEntry()
    pe.load_control_from_wapt(os.getcwd())
    pe.version = lastestversion + "-0"
    pe.save_control_to_wapt(os.getcwd())
