# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():
    # Uninstalling older versions of the software
    for to_uninstall in installed_softwares(name="Harmony SASE"):
        print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
        killalltasks(ensure_list(control.impacted_process))
        run(uninstall_cmd(to_uninstall["key"]))
        wait_uninstallkey_absent(to_uninstall["key"])
        if isdir(to_uninstall["install_location"]):
            remove_tree(to_uninstall["install_location"])

    bin_name = glob.glob('Harmony_SASE_*.msi')[0]
    
    install_msi_if_needed(bin_name)
    

    



