# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import glob


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = proxies = get_proxies()
        
    dict_arch = {"x64":"-win64.exe","x86":"-win32.exe"}

    for elem in bs_find_all('https://graphviz.org/download/',"a","href",proxies=proxies):
        if elem.get('href').endswith(dict_arch[control.architecture]): 
            url_download = elem.get('href')
            break

    filename = url_download.split('/')[-1]
    last_version = filename.split('-')[-2]

    if not isfile(filename):
        package_updated = True
        wget(url_download,filename,proxies=proxies)

    for f in glob.glob('*.exe'):
        if f != filename:
            remove_file(f)

    control.set_software_version(last_version)
    control.save_control_to_wapt()

    return package_updated
