# -*- coding: utf-8 -*-
from setuphelpers import *


app_name = "gopass"
app_dir = makepath(programfiles, app_name)
app_path = makepath(app_dir, f"{app_name}.exe")


def install():
    # Declaring local variables
    zip_name = glob.glob("gopass-*-windows-amd64.zip")[0]
    unzip_dest = "."
    unzip_dest = app_name
    unzipped_dir = zip_name.rsplit(".", 1)[0]
    unzipped_dir = app_name

    # Installing software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir) and force:
        remove_tree(app_dir)
    mkdirs(app_dir)
    print("Extracting: %s to: %s" % (zip_name, app_dir))
    unzip(zip_name, unzip_dest)
    copytree2(unzipped_dir, app_dir, onreplace=default_overwrite)

    icon_path = glob.glob("icon_0000.ico")[0]
    filecopyto(icon_path, app_dir)

    # Creating custom shortcuts
    create_programs_menu_shortcut(app_name, target=app_path, icon=makepath(app_dir, "icon_0000.ico"))


def uninstall():
    # Uninstalling software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir):
        remove_tree(app_dir)

    # Removing shortcuts
    remove_programs_menu_shortcut(app_name)
