# -*- coding: utf-8 -*-
from setuphelpers import *

bin_path = makepath("/", "usr", "local", "bin")
app_path = "/opt/gopass"

def install():
    # Extraction and copying to /opt/typst
    extract_path = glob.glob("gopass-*-darwin-amd64.tar.gz")[0]
    run(f"tar -xJvf {extract_path}")
    char_len = len(extract_path) - len('.tar.gz')
    extract_path = extract_path[:char_len]
    bin_name = "gopass"
    print(f"copying gopass to {app_path}")
    if not isdir(app_path):
        mkdirs(app_path)
    filecopyto(bin_name, app_path)
    # Creation of symlink
    if not isfile(f"{bin_path}/gopass"):
        print("create typst alias in path")
        os.symlink(f"{app_path}/gopass", f"{bin_path}/gopass")
    if isdir(extract_path):
        remove_tree(extract_path)


def uninstall():
    # Removing of symlink
    if isfile(f"{bin_path}/gopass"):
        remove_file(f"{bin_path}/gopass")
    # Removing of the software 
    if isdir(app_path):
        remove_tree(app_path)

