# -*- coding: utf-8 -*-
from setuphelpers import *
from  configparser import ConfigParser


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    api_url = f"https://www.glarysoft.com/update/update.php?s=glary_utilities&c=10000&v={control.get_software_version()}"

    config = ConfigParser()
    config.read_string(wgets(api_url, proxies=proxies))

    version = config['Version']['Version']
    download_url = config['Version']['UpdateUrl']
    latest_bin = download_url.rsplit("/", 1)[-1]
    latest_bin_extension = latest_bin.rsplit('.', 1)[-1]

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated

