# -*- coding: utf-8 -*-
from setuphelpers import *


app_path = r"C:\Program Files\Git\cmd\git.exe"


def get_soft_version(key):
    return get_file_properties(app_path)["FileVersion"]


def install():
    app_uninstallkey = "Git_is1"
    bin_name = glob.glob("Git-*.exe")[0]
    install_exe_if_needed(
        bin_name,
        silentflags='/LOADINF="git.inf" /VERYSILENT /SUPPRESSMSGBOXES /CLOSEAPPLICATIONS /NORESTART',
        key=app_uninstallkey,
        min_version=control.get_software_version(),
        get_version=get_soft_version,
        timeout=900,
    )

    # Disable credential provider web detection
    run(f'"{app_path}" config --global credential.provider generic')