# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    releases_stable = wgets("https://www.gimp.org/gimp_versions.json", as_json=True)["STABLE"]
    latest_release = max(releases_stable, key=lambda r: Version(r['version']))

    build_dict = {
        'windows-all': ('windows', 'org.gimp.GIMP_official'),
        'linux-x64': ('appimage', 'org.gimp.GIMP_official.AppImage.x86_64'),
        'linux-arm64': ('appimage', 'org.gimp.GIMP_official.AppImage.aarch64'),
        'darwin-x64': ('macos', 'org.gimp.GIMP_official.x86_64'),
        'darwin-arm': ('macos', 'org.gimp.GIMP_official.arm64'),
    }

    os_type = control.target_os + "-" + ensure_list(control.architecture)[0]
    target_os, build = build_dict[os_type]

    latest_filename = max(
        (release for release in latest_release[target_os] if release['build-id'] == build),
        key=lambda r: r['date']
    )

    version = f"{latest_release['version']}.{latest_filename['revision']}" if latest_filename.get('revision') else latest_release["version"]
    latest_bin = latest_filename['filename']
    latest_bin_extension = latest_bin.rsplit('.', 1)[-1]

    download_url = f"https://download.gimp.org/gimp/v{Version(version, 2)}/{target_os}/{latest_filename['filename']}"

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated
