# -*- coding: utf-8 -*-
from setuphelpers import *


def install():


    # Uninstalling the software
    for to_uninstall in installed_softwares("Gimp"):
        if Version(to_uninstall["version"]) < Version(control.get_software_version()) or force:
            print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
            killalltasks(ensure_list(control.impacted_process))
            run(uninstall_cmd(to_uninstall["key"]))
            wait_uninstallkey_absent(to_uninstall["key"])

    # Specific app values
    version = control.get_software_version().rsplit(".",2)[0]
    short_version = version.split(".")[0] 
    sys_conf_file = makepath(programfiles, f"GIMP {short_version}", "etc", "gimp", f"{version}", "gimprc")
    package_version = control.version.split("-")[0]
    bin_name = "gimp-%s-setup.exe" % package_version
    bin_name_glob = glob.glob(bin_name.split(".")[0] + "*")[0]

    # Installing the package
    install_exe_if_needed(bin_name_glob, silentflags="/VERYSILENT /NORESTART /RESTARTEXITCODE=3010 /SUPPRESSMSGBOXES /SP- --disable-check-update /ALLUSERS", key=f"GIMP-{short_version}_is1", min_version=package_version, timeout=1200)

    # Disabling update check
    if isfile(sys_conf_file):
        fichier = open(sys_conf_file, "r")
        data = fichier.read()
        fichier.close()

        if "# (check-updates yes)" in data:
            data = data.replace("# (check-updates yes)", "(check-updates no)")
        if "(check-updates yes)" in data:
            data = data.replace("(check-updates yes)", "(check-updates no)")

        fichier = open(sys_conf_file, "w")
        fichier.write(data)
        fichier.close()


def get_version_from_binary(filename, property_name="ProductVersion"):
    r"""Get installer version from file informations, for now, only exe and msi files are compatibles

    Args:
        filename (str): path to the file
        property_name (str): selected property

    Returns:
        str: version number

    """
    if filename.endswith(".msi"):
        return get_msi_properties(filename)[property_name]
    else:
        return get_file_properties(filename)[property_name]


def uninstall(): 
    
    # Uninstalling the software
    for to_uninstall in installed_softwares("Gimp"):
        print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
        killalltasks(ensure_list(control.impacted_process))
        run(uninstall_cmd(to_uninstall["key"]))
        wait_uninstallkey_absent(to_uninstall["key"])