# -*- coding: utf-8 -*-
from setuphelpers import *


def install():
    # Initializing variables
    bin_name = glob.glob("*Gajim*.exe")[0]

    def get_version(key):
        if "+" in key["version"]:
            if "." in key["version"].split("+", 1)[1]:
                return key["version"].split("+", 1)[0] + "." + key["version"].split("+")[1].split(".", 1)[1]
            else:
                return key["version"].split("+", 1)[0]
        else:
            return key["version"]

    # Uninstalling older versions of the software
    for uninstall in installed_softwares(name=r"\bGajim\b"):
        if get_version(uninstall) < control.get_software_version() or force:
            print("Removing: %s (%s)" % (uninstall["name"], uninstall["version"]))
            run(uninstall_cmd(uninstall["key"]))
            wait_uninstallkey_absent(uninstall["key"])

    # Installing the package
    print("Installing: %s" % bin_name)
    install_exe_if_needed(
        bin_name,
        silentflags="/S",
        key="Gajim",
        min_version=control.get_software_version(),
        get_version=get_version,
    )
