# -*- coding: utf-8 -*-
from setuphelpers import *

def update_package():

    # Initializing variables
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    url = "https://gajim.org/download/"

    # Getting latest version from official sources
    print("URL used is: %s" % url)
    for bs_search in bs_find_all(url, "a", "href", proxies=proxies):
        if bs_search["href"].endswith("-64bit.exe"):
            version = bs_search["href"].split("-")[1]
            latest_bin = bs_search["href"].split("/")[-1]
            # latest_bin = bin_contains + version
            url_dl = bs_search["href"]
            break

    print("Latest %s version is: %s" % (control.name, version))
    print("Download url is: %s" % url_dl)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(url_dl, latest_bin, proxies=proxies)

    # Changing version of the package
    control.set_software_version(version)
    control.save_control_to_wapt()
    print("Changing package version to: %s in WAPT\\control" % control.version)

    # Deleting outdated binaries
    remove_outdated_binaries(version)