# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import waptlicences

def table_to_dict(table):
    return {
        a.get_text(strip=True): a.get("href")
        for row in table.find("tbody").find_all("tr")[1:]
        for th in row.find_all("th")
        for a in [th.find("a")] if a
    }

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    base_url = "https://sourceforge.net/projects/freeplane/files/freeplane%20stable/"
    user_agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36"
    
    source_forge_releases = table_to_dict(bs_find(base_url, 'table', user_agent=user_agent))
    
    history_filename = next(item for item in source_forge_releases if "history_en" in item)
    version = history_filename.split('-')[-1].removesuffix('.txt')
    
    download_dict = {
        'windows-all': f'Freeplane-Setup-{version}.exe',
        'debian_based-all': f'freeplane_{version}~upstream-1_all.deb',
        'darwin-x64': f'Freeplane-{version}-intel.dmg',
        'darwin-arm': f'Freeplane-{version}-apple.dmg'
    }

    os_type = control.target_os + "-" + ensure_list(control.architecture)[0]
    latest_bin = next(item for item in source_forge_releases if download_dict[os_type] == item)
    
    download_url = source_forge_releases[latest_bin]
    latest_bin_extension = latest_bin.rsplit(".", 1)[-1]

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, target=latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated
