# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()
{
   "key":"Ablaze Floorp 11.17.8 (x64 en-US)",
   "name":"Ablaze Floorp (x64 en-US)",
   "version":"11.17.8",
   "install_date":"",
   "install_location":"C:\\Program Files\\Ablaze Floorp",
   "uninstall_string":"\"C:\\Program Files\\Ablaze Floorp\\uninstall\\helper.exe\"",
   "publisher":"Mozilla",
   "system_component":0,
   "win64":true
  }

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():
    # Declaring local variables
    version = control.get_software_version()
    # Construire la clé dynamique
    key = f"Ablaze Floorp {version} (x64 en-US)"

    # Uninstalling older versions of the software
    for to_uninstall in installed_softwares(name="Ablaze Floorp"):
        if Version(to_uninstall["version"]) < Version(control.get_software_version()):
            print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
            killalltasks(ensure_list(control.impacted_process))
            run(uninstall_cmd(to_uninstall["key"]))
            wait_uninstallkey_absent(to_uninstall["key"])
            if isdir(to_uninstall["install_location"]):
                remove_tree(to_uninstall["install_location"])

    # Installing the software
    install_exe_if_needed("floorp-windows-x86_64.installer.exe", silentflags="/S", name="Ablaze Floorp", min_version=control.get_software_version(),get_version=get_soft_version)

def get_soft_version(key):
    return key["version"].split("@")[-1]

