# -*- coding: utf-8 -*-
from setuphelpers import *
import tempfile


# Fix for CVE-2021-36934: Summer of SAM : https://t.co/kz3eWzVAu4
# Vulnerability are found only in windows server version 2019 freshly installed and windows computers 1809 or more freshly installed, if upgraded from earlier version the vulnerability shouldn't be present. We check for builtin\users and if present we delete the shadow copy


def install():
    Os_Name = get_os_name()
    if Os_Name != "Windows":
        print("OS is not vulnerable")
    else:
        output_temp_file = tempfile.mktemp()
        print(output_temp_file)
        output = run('icacls %%windir%%\system32\config\sam /save "%s"' % output_temp_file)
        # beware of localized versions
        print(output)
        with open(output_temp_file, encoding="utf-16-le") as f:
            acl_content = f.read()
        acl_content = acl_content.lstrip("sam").strip()

        # print("current acl on %%windir%%\system32\config\sam : %s " % acl_content)

        if ";BU)" in acl_content:
            print(r"ACL on %windir%\system32\config has user inheritence, disabling with cmd : ")
            cmd = "icacls %windir%\system32\config\*.* /inheritance:e"
            print(cmd)
            run(cmd)
        else:
            print("OK : This machine is not vulnerable")
            return

        print("we need to delete all volume shadow copy to finish this security bug fix")

        print("listing volume shadow before deletion for %s " % os.environ["SYSTEMDRIVE"])
        return_output = run(r"vssadmin list shadows /for=%systemdrive%", accept_returncodes=[0, 1])

        if return_output.returncode == 1:
            print(return_output)

            # vssadmin is rubbish and it is localised by default, here we only check for French and English locale
            if "Il n'existe aucun élément correspondant à la requête" in return_output or "No items found that satisfy the query." in return_output:
                print("no volume shadow to delete")

            else:
                error("output is different than expected. If the computer is in another locale than French and English, please edit the package")

        else:
            print("=================================")
            print("deleting volume shadow for %s" % os.environ["SYSTEMDRIVE"])
            print(run(r"vssadmin delete shadows /for=%systemdrive% /quiet"))

            print("=================================")
            print("listing volume shadow after deletion for %s" % os.environ["SYSTEMDRIVE"])
            return_output = run(r"vssadmin list shadows /for=%systemdrive%", accept_returncodes=[0, 1])

            if "Il n'existe aucun élément correspondant à la requête" in return_output or "No items found that satisfy the query." in return_output:
                print("OK : shadow copies properly deleted")
            else:
                error("output is different than expected. If the computer is in another locale than French and English, please edit the package")


def audit():
    output_temp_file = tempfile.mktemp()
    print(output_temp_file)
    output = run('icacls %%windir%%\system32\config\sam /save "%s"' % output_temp_file)
    # beware of localized versions
    print(output)
    with open(output_temp_file, encoding="utf-16-le") as f:
        acl_content = f.read()
    acl_content = acl_content.lstrip("sam").strip()

    # print("current acl on %%windir%%\system32\config\sam : %s " % acl_content)

    if ";BU)" in acl_content:
        print(r"ACL on %windir%\system32\config has user inheritence, disabling with cmd : ")
        cmd = "icacls %windir%\system32\config\*.* /inheritance:e"
        print(cmd)
        run(cmd)
        return "WARNING"
    else:
        print("OK : This machine is not vulnerable")
        return "OK"
