# -*- coding: utf-8 -*-
from setuphelpers import *


def install():
    bin_name = glob.glob("FileZilla_*.exe")[0]
    install_exe_if_needed(
        bin_name,
        silentflags="/S",
        key="FileZilla Client",
        min_version=control.get_software_version(),
    )


def session_setup():
    print("Disabling: update check")
    # C:\Users\username\AppData\Roaming\FileZilla\filezilla.xml
    user_conf_dir = makepath(application_data, "FileZilla")
    user_conf_file = makepath(user_conf_dir, "filezilla.xml")
    user_conf_content = r"""<FileZilla3 platform="windows" version="">
	<Settings>
		<Setting name="Update Check">0</Setting>
	</Settings>
</FileZilla3>"""

    if not isdir(user_conf_dir):
        mkdirs(user_conf_dir)

    if not isfile(user_conf_file):
        file_open = open(user_conf_file, "w")
        file_open.write(user_conf_content)
        file_open.close()

    else:
        import xml.etree.ElementTree as ET

        user_conf_tree = ET.parse(user_conf_file)
        user_conf_content = user_conf_tree.getroot()

        for conf in user_conf_content.iter("Settings"):
            for child in conf:
                if child.get("name") == "Update Check":
                    child.text = "0"

        user_conf_tree.write(user_conf_file, encoding="utf-8", xml_declaration=True)
