from setupdevhelpers import *
import glob
import waptlicences
import xml.etree.ElementTree as ET


def update_package():
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    app_name = control.name

    download_dict = {
        "windows": "https://desktop.figma.com/win/releases.xml",
        "darwin": "https://desktop.figma.com/mac-universal/releases.xml"
    }

    website_xml_data = wgets(download_dict[control.target_os]).decode('utf-8')
    root = ET.fromstring(website_xml_data)
    first_item = root.find('./channel/item')

    download_url = first_item.find('guid').text
    latest_bin = download_url.rsplit("/", 1)[-1]
    latest_bin_extension = latest_bin.rsplit('.', 1)[-1]
    version = latest_bin.split('-')[-1].replace(f'.{latest_bin_extension}', '')
    
    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    expected_issuer = 'Figma, Inc.'
    sign_name = waptlicences.check_msi_signature(latest_bin)[0]
    if sign_name != expected_issuer:
        error(f'Bad issuer {sign_name} != {expected_issuer} ')

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated