# -*- coding: utf-8 -*-
from setuphelpers import *



def install():
    # Declaring local variables
    bin_name = glob.glob("Figma-*.msi")[0]

    uninstall_older_version()

    # Installing the software
    install_msi_if_needed(
        bin_name,
        name="Figma \(Machine \- MSI\)",
        min_version=control.get_software_version()
    )

def uninstall_older_version():

    # Uninstalling older version of the software that can remains
    for to_uninstall in installed_softwares(name="Figma \(Machine \- MSI\)"):
        if Version(to_uninstall["version"]) < Version(control.get_software_version()):
            print(f"Removing: {to_uninstall['name']} ({to_uninstall['version']})")
            killalltasks(ensure_list(control.impacted_process))
            run(uninstall_cmd(to_uninstall["key"]))
            wait_uninstallkey_absent(to_uninstall["key"])


