# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    api_url = "https://api.github.com/repos/Rem0o/FanControl.Releases/releases/latest"
    releases_dict = wgets(api_url, proxies=proxies, as_json=True)

    for asset in releases_dict["assets"]:
        if asset["name"].endswith(".exe") and "10_0" in asset["name"]:
            download_url = asset["browser_download_url"]
            latest_bin = asset['name']
            latest_bin_extension = latest_bin.rsplit('.', 1)[-1]
            version = releases_dict["tag_name"].replace("V", "")
            break

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, target=latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated

