# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    download_dict = {
        "windows": "https://win.desktop.evernote.com/builds/Evernote-latest.exe",
    }
    download_url = download_dict[ensure_list(control.target_os)[0]]
    latest_bin = download_url.split("/")[-1]

    # Deleting binaries
    remove_outdated_binaries("*")

    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies, verify_cert="win.desktop.evernote.com.crt")
    else:
        print("Binary is present: %s" % latest_bin)

    # Checking version from file
    if get_os_name() == "Windows" and "windows" in control.target_os.lower():
        version = get_version_from_binary(latest_bin)
    else:
        version = control.get_software_version()

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return package_updated

    # # Changing version of the package and validating update-package-sources
    # return complete_control_version(control, version)
