# -*- coding: utf-8 -*-
from setuphelpers import *

app_name = "etcd"
app_dir = makepath(programfiles, app_name)
app_path = makepath(app_dir, f"{app_name}.exe")


def install():
    # Declaring local variables
    zip_name = glob.glob("etcd-v*-windows-amd64.zip")[0]
    unzip_dest = "."
    unzipped_dir = zip_name.rsplit(".", 1)[0]

    # Installing software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir) and force:
        remove_tree(app_dir)
    mkdirs(app_dir)
    print("Extracting: %s to: %s" % (zip_name, app_dir))
    unzip(zip_name, unzip_dest)
    copytree2(unzipped_dir, app_dir, onreplace=default_overwrite)

    # Creating custom shortcuts
    create_desktop_shortcut(app_name, target=app_path)
    create_programs_menu_shortcut(app_name, target=app_path)


def uninstall():
    # Uninstalling software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir):
        remove_tree(app_dir)

    # Removing shortcuts
    remove_desktop_shortcut(app_name)
    remove_programs_menu_shortcut(app_name)
