# -*- coding: utf-8 -*-
from setuphelpers import *
import json
import re
import requests


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    # Getting latest version from official sources
    re_versions = re.compile(r'otp_win64_(\d+\.\d+)\.exe')
    index = wgets("https://erlang.org/download/", proxies=proxies)

    for versionotp in sorted(re_versions.findall(index), key=lambda p: (Version(p)), reverse=True):
        if control.architecture == "x64":
            latest_bin = "otp_win64_%s.exe" % versionotp
            download_url = "https://erlang.org/download/" + latest_bin

        if not requests.head(download_url, proxies=proxies).status_code == 404:
            version = versionotp
            break

    # remove files
    for f in glob.glob("*.exe"):
        if f != latest_bin:
            remove_file(f)

    # Downloading latest binaries
    wget(download_url, latest_bin, proxies=proxies)

    version =get_version_from_binary(latest_bin)
    control.set_software_version(version)
    control.save_control_to_wapt()
